/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.mantle.item.TooltipItem;
import slimeknights.mantle.registration.deferred.BlockEntityTypeDeferredRegister;
import slimeknights.mantle.registration.deferred.EntityTypeDeferredRegister;
import slimeknights.mantle.registration.deferred.FluidDeferredRegister;
import slimeknights.mantle.registration.deferred.MenuTypeDeferredRegister;
import slimeknights.mantle.util.SupplierCreativeTab;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.registration.BlockDeferredRegisterExtension;
import slimeknights.tconstruct.common.registration.ConfiguredFeatureDeferredRegister;
import slimeknights.tconstruct.common.registration.ItemDeferredRegisterExtension;
import slimeknights.tconstruct.common.registration.PlacedFeatureDeferredRegister;
import slimeknights.tconstruct.library.modifiers.util.ModifierDeferredRegister;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.SlimeType;

public abstract class TinkerModule {
    protected static final BlockDeferredRegisterExtension BLOCKS = new BlockDeferredRegisterExtension("tconstruct");
    protected static final ItemDeferredRegisterExtension ITEMS = new ItemDeferredRegisterExtension("tconstruct");
    protected static final FluidDeferredRegister FLUIDS = new FluidDeferredRegister("tconstruct");
    protected static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"tconstruct");
    protected static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"tconstruct");
    protected static final ModifierDeferredRegister MODIFIERS = ModifierDeferredRegister.create("tconstruct");
    protected static final BlockEntityTypeDeferredRegister BLOCK_ENTITIES = new BlockEntityTypeDeferredRegister("tconstruct");
    protected static final EntityTypeDeferredRegister ENTITIES = new EntityTypeDeferredRegister("tconstruct");
    protected static final MenuTypeDeferredRegister MENUS = new MenuTypeDeferredRegister("tconstruct");
    protected static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"tconstruct");
    protected static final DeferredRegister<GlobalLootModifierSerializer<?>> GLOBAL_LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.LOOT_MODIFIER_SERIALIZERS, (String)"tconstruct");
    protected static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"tconstruct");
    protected static final ConfiguredFeatureDeferredRegister CONFIGURED_FEATURES = new ConfiguredFeatureDeferredRegister("tconstruct");
    protected static final PlacedFeatureDeferredRegister PLACED_FEATURES = new PlacedFeatureDeferredRegister("tconstruct");
    protected static final DeferredRegister<StructureFeature<?>> STRUCTURE_FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"tconstruct");
    protected static final DeferredRegister<ConfiguredStructureFeature<?, ?>> CONFIGURED_STRUCTURE_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122882_, (String)"tconstruct");
    protected static final DeferredRegister<StructurePieceType> STRUCTURE_PIECE = DeferredRegister.create((ResourceKey)Registry.f_122842_, (String)"tconstruct");
    protected static final DeferredRegister<BlockStateProviderType<?>> BLOCK_STATE_PROVIDER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_STATE_PROVIDER_TYPES, (String)"tconstruct");
    public static final CreativeModeTab TAB_GENERAL = new SupplierCreativeTab("tconstruct", "general", () -> new ItemStack((ItemLike)TinkerCommons.slimeball.get((Enum)SlimeType.SKY)));
    protected static final Item.Properties HIDDEN_PROPS = new Item.Properties();
    protected static final Item.Properties GENERAL_PROPS = new Item.Properties().m_41491_(TAB_GENERAL);
    protected static final Function<Block, ? extends BlockItem> HIDDEN_BLOCK_ITEM = b -> new BlockItem(b, HIDDEN_PROPS);
    protected static final Function<Block, ? extends BlockItem> GENERAL_BLOCK_ITEM = b -> new BlockItem(b, GENERAL_PROPS);
    protected static final Function<Block, ? extends BlockItem> GENERAL_TOOLTIP_BLOCK_ITEM = b -> new BlockTooltipItem(b, GENERAL_PROPS);
    protected static final Supplier<Item> TOOLTIP_ITEM = () -> new TooltipItem(GENERAL_PROPS);

    protected TinkerModule() {
        TConstruct.sealTinkersClass(this, "TinkerModule", "This is a bug with the mod containing that class, they should create their own deferred registers.");
    }

    public static void initRegisters() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(bus);
        ITEMS.register(bus);
        FLUIDS.register(bus);
        MOB_EFFECTS.register(bus);
        PARTICLE_TYPES.register(bus);
        MODIFIERS.register(bus);
        BLOCK_ENTITIES.register(bus);
        ENTITIES.register(bus);
        MENUS.register(bus);
        RECIPE_SERIALIZERS.register(bus);
        GLOBAL_LOOT_MODIFIERS.register(bus);
        TinkerRecipeTypes.init(bus);
        FEATURES.register(bus);
        CONFIGURED_FEATURES.register(bus);
        PLACED_FEATURES.register(bus);
        STRUCTURE_FEATURES.register(bus);
        STRUCTURE_PIECE.register(bus);
        CONFIGURED_STRUCTURE_FEATURES.register(bus);
        BLOCK_STATE_PROVIDER_TYPES.register(bus);
    }

    protected static BlockBehaviour.Properties builder(Material material, SoundType soundType) {
        return BlockBehaviour.Properties.m_60939_((Material)material).m_60918_(soundType);
    }

    protected static BlockBehaviour.Properties builder(Material material, MaterialColor color, SoundType soundType) {
        return BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)color).m_60918_(soundType);
    }

    protected static BlockBehaviour.Properties metalBuilder(MaterialColor color) {
        return TinkerModule.builder(Material.f_76279_, color, SoundType.f_56743_).m_60999_().m_60978_(5.0f);
    }

    protected static BlockBehaviour.Properties glassBuilder(MaterialColor color) {
        return TinkerModule.builder(Material.f_76275_, color, SoundType.f_56744_).m_60978_(0.3f).m_60955_().m_60922_(Blocks::m_50778_).m_60924_(Blocks::m_50805_).m_60960_(Blocks::m_50805_).m_60971_(Blocks::m_50805_);
    }

    protected static BlockBehaviour.Properties woodBuilder(MaterialColor color) {
        return TinkerModule.builder(Material.f_76320_, color, SoundType.f_56736_).m_60999_().m_60913_(2.0f, 7.0f);
    }

    protected static ResourceLocation resource(String path) {
        return TConstruct.getResource(path);
    }
}

